/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.TowingConnection;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.components.AEntityG_Towable;
import minecrafttransportsimulator.entities.instances.AEntityVehicleE_Powered;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.PartEngine;
import minecrafttransportsimulator.entities.instances.PartPropeller;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.systems.ConfigSystem;

public class EntityVehicleF_Physics
extends AEntityVehicleE_Powered {
    public final ComputedVariable aileronInputVar;
    public final ComputedVariable aileronAngleVar;
    public final ComputedVariable aileronTrimVar;
    public final ComputedVariable aileronAreaVar;
    public static final double MAX_AILERON_ANGLE = 25.0;
    public static final double MAX_AILERON_TRIM = 10.0;
    public static final double AILERON_DAMPEN_RATE = 0.6;
    public final ComputedVariable elevatorInputVar;
    public final ComputedVariable elevatorAngleVar;
    public final ComputedVariable elevatorTrimVar;
    public final ComputedVariable elevatorAreaVar;
    public static final double MAX_ELEVATOR_ANGLE = 25.0;
    public static final double MAX_ELEVATOR_TRIM = 10.0;
    public static final double ELEVATOR_DAMPEN_RATE = 0.6;
    public final ComputedVariable rudderInputVar;
    public final ComputedVariable rudderAngleVar;
    public final ComputedVariable rudderTrimVar;
    public final ComputedVariable rudderAreaVar;
    public static final double MAX_RUDDER_ANGLE = 45.0;
    public static final double MAX_RUDDER_TRIM = 10.0;
    public static final double RUDDER_DAMPEN_RATE = 2.0;
    public static final double RUDDER_DAMPEN_RETURN_RATE = 4.0;
    public static final short MAX_FLAP_ANGLE_REFERENCE = 350;
    public final ComputedVariable wingAreaVar;
    public final ComputedVariable wingSpanVar;
    public final ComputedVariable flapDesiredAngleVar;
    public final ComputedVariable flapActualAngleVar;
    public final ComputedVariable autopilotValueVar;
    public final ComputedVariable autolevelEnabledVar;
    public final ComputedVariable openTopVar;
    public boolean turningLeft;
    public boolean turningRight;
    public byte turningCooldown;
    public double airDensity;
    public double seaLevel;
    public int controllerCount;
    public IWrapperPlayer lastController;
    public double indicatedSpeed;
    private boolean hasRotors;
    private double trackAngle;
    private final Point3D normalizedVelocityVector;
    private final Point3D verticalVector;
    private final Point3D sideVector;
    private final Point3D hitchPrevOffset;
    private final Point3D hitchCurrentOffset;
    private final Set<AEntityG_Towable<?>> towedEntitiesCheckedForWeights;
    public final ComputedVariable dragCoefficientVar;
    public final ComputedVariable ballastControlVar;
    public final ComputedVariable ballastVolumeVar;
    public final ComputedVariable waterBallastFactorVar;
    public final ComputedVariable gravityFactorVar;
    public final ComputedVariable axleRatioVar;
    private double wingLiftCoeff;
    private double aileronLiftCoeff;
    private double elevatorLiftCoeff;
    private double rudderLiftCoeff;
    private double dragCoeff;
    private double dragForce;
    private double wingForce;
    private double aileronForce;
    private double elevatorForce;
    private double rudderForce;
    private double ballastForce;
    private double gravitationalForce;
    private final Point3D thrustForce;
    private double thrustForceValue;
    private final Point3D towingThrustForce;
    private final Point3D totalForce;
    private double momentRoll;
    private double momentPitch;
    private double momentYaw;
    private double aileronTorque;
    private double elevatorTorque;
    private double rudderTorque;
    private final Point3D thrustTorque;
    private final Point3D totalTorque;
    private final Point3D rotorRotation;

    public EntityVehicleF_Physics(AWrapperWorld world, IWrapperPlayer placingPlayer, ItemVehicle item, IWrapperNBT data) {
        super(world, placingPlayer, item, data);
        this.seaLevel = ((Integer)ConfigSystem.settings.general.seaLevel.value).intValue();
        this.normalizedVelocityVector = new Point3D();
        this.verticalVector = new Point3D();
        this.sideVector = new Point3D();
        this.hitchPrevOffset = new Point3D();
        this.hitchCurrentOffset = new Point3D();
        this.towedEntitiesCheckedForWeights = new HashSet();
        this.thrustForce = new Point3D();
        this.towingThrustForce = new Point3D();
        this.totalForce = new Point3D();
        this.thrustTorque = new Point3D();
        this.totalTorque = new Point3D();
        this.rotorRotation = new Point3D();
        this.aileronInputVar = new ComputedVariable(this, "input_aileron", data);
        this.addVariable(this.aileronInputVar);
        this.aileronAngleVar = new ComputedVariable(this, "aileron", data);
        this.addVariable(this.aileronAngleVar);
        this.aileronTrimVar = new ComputedVariable(this, "trim_aileron", data);
        this.addVariable(this.aileronTrimVar);
        this.aileronAreaVar = new ComputedVariable(this, "aileronArea");
        this.addVariable(this.aileronAreaVar);
        this.elevatorInputVar = new ComputedVariable(this, "input_elevator", data);
        this.addVariable(this.elevatorInputVar);
        this.elevatorAngleVar = new ComputedVariable(this, "elevator", data);
        this.addVariable(this.elevatorAngleVar);
        this.elevatorTrimVar = new ComputedVariable(this, "trim_elevator", data);
        this.addVariable(this.elevatorTrimVar);
        this.elevatorAreaVar = new ComputedVariable(this, "elevatorArea");
        this.addVariable(this.elevatorAreaVar);
        this.rudderInputVar = new ComputedVariable(this, "input_rudder", data);
        this.addVariable(this.rudderInputVar);
        this.rudderAngleVar = new ComputedVariable(this, "rudder", data);
        this.addVariable(this.rudderAngleVar);
        this.rudderTrimVar = new ComputedVariable(this, "trim_rudder", data);
        this.addVariable(this.rudderTrimVar);
        this.rudderAreaVar = new ComputedVariable(this, "rudderArea");
        this.addVariable(this.rudderAreaVar);
        this.wingAreaVar = new ComputedVariable(this, "wingArea");
        this.addVariable(this.wingAreaVar);
        this.wingSpanVar = new ComputedVariable(this, "wingSpan");
        this.addVariable(this.wingSpanVar);
        this.flapDesiredAngleVar = new ComputedVariable(this, "flaps_setpoint", data);
        this.addVariable(this.flapDesiredAngleVar);
        this.flapActualAngleVar = new ComputedVariable(this, "flaps_actual", data);
        this.addVariable(this.flapActualAngleVar);
        this.autopilotValueVar = new ComputedVariable(this, "autopilot", data);
        this.addVariable(this.autopilotValueVar);
        this.autolevelEnabledVar = new ComputedVariable(this, "auto_level", data);
        this.addVariable(this.autolevelEnabledVar);
        this.openTopVar = new ComputedVariable(this, "hasOpenTop", data);
        this.addVariable(this.openTopVar);
        this.dragCoefficientVar = new ComputedVariable(this, "dragCoefficient");
        this.addVariable(this.dragCoefficientVar);
        this.ballastControlVar = new ComputedVariable(this, "ballastControl", data);
        this.addVariable(this.ballastControlVar);
        this.ballastVolumeVar = new ComputedVariable(this, "ballastVolume");
        this.addVariable(this.ballastVolumeVar);
        this.waterBallastFactorVar = new ComputedVariable(this, "waterBallastFactor");
        this.addVariable(this.waterBallastFactorVar);
        this.gravityFactorVar = new ComputedVariable(this, "gravityFactor");
        this.addVariable(this.gravityFactorVar);
        this.axleRatioVar = new ComputedVariable(this, "axleRatio");
        this.addVariable(this.axleRatioVar);
    }

    @Override
    public void update() {
        super.update();
        this.world.beginProfiling("VehicleF_Level", true);
        this.indicatedSpeed = this.axialVelocity * this.speedFactor * 20.0;
        this.verticalVector.set(0.0, 1.0, 0.0).rotate(this.orientation);
        this.normalizedVelocityVector.set(this.motion).normalize();
        this.sideVector.set(this.verticalVector.crossProduct(this.headingVector));
        this.world.endProfiling();
    }

    @Override
    public boolean requiresDeltaUpdates() {
        return true;
    }

    @Override
    public double getMass() {
        double combinedMass = super.getMass();
        if (!this.towingConnections.isEmpty()) {
            for (TowingConnection connection : this.towingConnections) {
                EntityVehicleF_Physics towedEntity = connection.towedVehicle;
                if (this.towedEntitiesCheckedForWeights.contains(towedEntity)) {
                    InterfaceManager.coreInterface.logError("Infinite loop detected on weight checking code!  Is a trailer towing the thing that's towing it?");
                    break;
                }
                this.towedEntitiesCheckedForWeights.add(towedEntity);
                combinedMass += ((AEntityF_Multipart)towedEntity).getMass();
                this.towedEntitiesCheckedForWeights.clear();
            }
        }
        return combinedMass;
    }

    @Override
    protected double getSteeringAngle() {
        return -this.rudderInputVar.currentValue / 45.0;
    }

    @Override
    protected void addToSteeringAngle(double degrees) {
        double delta = this.rudderInputVar.currentValue - degrees > 45.0 ? 45.0 - this.rudderInputVar.currentValue : (this.rudderInputVar.currentValue - degrees < -45.0 ? -45.0 - this.rudderInputVar.currentValue : -degrees);
        this.rudderInputVar.adjustBy(delta, true);
    }

    @Override
    public void setVariableDefaults() {
        super.setVariableDefaults();
        this.aileronAreaVar.setTo(((JSONVehicle)this.definition).motorized.aileronArea, false);
        this.aileronAngleVar.setTo(this.aileronInputVar.currentValue, false);
        this.elevatorAngleVar.setTo(this.elevatorInputVar.currentValue, false);
        this.elevatorAreaVar.setTo(((JSONVehicle)this.definition).motorized.elevatorArea, false);
        this.rudderAngleVar.setTo(this.rudderInputVar.currentValue, false);
        this.rudderAreaVar.setTo(((JSONVehicle)this.definition).motorized.rudderArea, false);
        this.wingAreaVar.setTo((double)((JSONVehicle)this.definition).motorized.wingArea + (double)(((JSONVehicle)this.definition).motorized.wingArea * 0.15f) * this.flapActualAngleVar.currentValue / 350.0, false);
        this.wingSpanVar.setTo(((JSONVehicle)this.definition).motorized.wingSpan, false);
        if (((JSONVehicle)this.definition).motorized.flapNotches != null && !((JSONVehicle)this.definition).motorized.flapNotches.isEmpty()) {
            if (this.flapActualAngleVar.currentValue < this.flapDesiredAngleVar.currentValue) {
                this.flapActualAngleVar.setTo(this.flapActualAngleVar.currentValue + (double)((JSONVehicle)this.definition).motorized.flapSpeed, false);
            } else if (this.flapActualAngleVar.currentValue > this.flapDesiredAngleVar.currentValue) {
                this.flapActualAngleVar.setTo(this.flapActualAngleVar.currentValue - (double)((JSONVehicle)this.definition).motorized.flapSpeed, false);
            }
            if (Math.abs(this.flapActualAngleVar.currentValue - this.flapDesiredAngleVar.currentValue) < (double)((JSONVehicle)this.definition).motorized.flapSpeed) {
                this.flapActualAngleVar.setTo(this.flapDesiredAngleVar.currentValue, false);
            }
        }
        this.openTopVar.setActive(((JSONVehicle)this.definition).motorized.hasOpenTop, false);
        this.dragCoefficientVar.setTo(((JSONVehicle)this.definition).motorized.dragCoefficient, false);
        this.ballastControlVar.setTo(this.elevatorInputVar.currentValue, false);
        this.ballastVolumeVar.setTo(((JSONVehicle)this.definition).motorized.ballastVolume, false);
        this.waterBallastFactorVar.setTo(((JSONVehicle)this.definition).motorized.waterBallastFactor, false);
        if (((JSONVehicle)this.definition).motorized.gravityFactor != 0.0f) {
            this.gravityFactorVar.setTo(((JSONVehicle)this.definition).motorized.gravityFactor, false);
        } else if (!((JSONVehicle)this.definition).motorized.isAircraft) {
            this.gravityFactorVar.setTo((Double)ConfigSystem.settings.general.gravityFactor.value, false);
        } else {
            this.gravityFactorVar.setTo(1.0, false);
        }
        this.axleRatioVar.setTo(((JSONVehicle)this.definition).motorized.axleRatio, false);
    }

    @Override
    protected void getForcesAndMotions() {
        this.hasRotors = false;
        this.thrustForce.set(0.0, 0.0, 0.0);
        this.thrustTorque.set(0.0, 0.0, 0.0);
        this.rotorRotation.set(0.0, 0.0, 0.0);
        this.thrustForceValue = 0.0;
        if (this.towedByConnection == null || !this.towedByConnection.hitchConnection.mounted) {
            for (APart part : this.allParts) {
                if (part instanceof PartEngine) {
                    this.thrustForceValue += ((PartEngine)part).addToForceOutput(this.thrustForce, this.thrustTorque);
                    continue;
                }
                if (!(part instanceof PartPropeller)) continue;
                PartPropeller propeller = (PartPropeller)part;
                this.thrustForceValue += propeller.addToForceOutput(this.thrustForce, this.thrustTorque);
                if (!((JSONPart)propeller.definition).propeller.isRotor || !this.groundDeviceCollective.isAnythingOnGround()) continue;
                this.hasRotors = true;
                if (!this.autopilotValueVar.isActive && this.autolevelEnabledVar.isActive) {
                    this.rotorRotation.set((-(this.elevatorAngleVar.currentValue + this.elevatorTrimVar.currentValue) - this.orientation.angles.x) / 25.0, -5.0 * this.rudderAngleVar.currentValue / 45.0, (this.aileronAngleVar.currentValue + this.aileronTrimVar.currentValue - this.orientation.angles.z) / 25.0);
                } else if (!this.autopilotValueVar.isActive) {
                    this.rotorRotation.set(-5.0 * this.elevatorAngleVar.currentValue / 25.0, -5.0 * this.rudderAngleVar.currentValue / 45.0, 5.0 * this.aileronAngleVar.currentValue / 25.0);
                } else {
                    this.rotorRotation.x = this.orientation.angles.x < -1.0 ? 1.0 : (this.orientation.angles.x > 1.0 ? -1.0 : -this.orientation.angles.x);
                    this.rotorRotation.z = this.orientation.angles.z < -1.0 ? 1.0 : (this.orientation.angles.z > 1.0 ? -1.0 : -this.orientation.angles.z);
                    this.rotorRotation.y = -5.0 * this.rudderAngleVar.currentValue / 45.0;
                }
                this.rotorRotation.x *= 1.0 + this.elevatorAreaVar.currentValue;
                this.rotorRotation.y *= 1.0 + this.rudderAreaVar.currentValue;
                this.rotorRotation.z *= 1.0 + this.aileronAreaVar.currentValue;
            }
        }
        if (this.towedByConnection == null) {
            this.airDensity = 1.225 * Math.pow(2.0, -(this.position.y - this.seaLevel) / (500.0 * (double)this.world.getMaxHeight() / 256.0));
            this.momentRoll = (double)((JSONVehicle)this.definition).motorized.emptyMass * (1.5 + this.fuelTank.getFluidLevel() / 10000.0);
            this.momentPitch = 2.0 * this.currentMass;
            this.momentYaw = 3.0 * this.currentMass;
            double towedThrust = this.getRecursiveTowingThrust();
            if (towedThrust != 0.0) {
                this.towingThrustForce.set(0.0, 0.0, towedThrust).rotate(this.orientation);
                this.thrustForce.add(this.towingThrustForce);
            }
            this.trackAngle = -Math.toDegrees(Math.asin(this.verticalVector.dotProduct(this.normalizedVelocityVector, true)));
            if (!((JSONVehicle)this.definition).motorized.hasThrustVectoring) {
                this.thrustTorque.x = 0.0;
                this.thrustTorque.z = 0.0;
            }
            if (((JSONVehicle)this.definition).motorized.isBlimp && Math.hypot(this.motion.x, this.motion.z) < 0.15 && (this.brakeVar.isActive || this.parkingBrakeVar.isActive)) {
                this.motion.x = 0.0;
                this.motion.z = 0.0;
                this.thrustForce.set(0.0, 0.0, 0.0);
                this.thrustTorque.set(0.0, 0.0, 0.0);
            }
            double yawAngleDelta = Math.toDegrees(Math.asin(this.sideVector.dotProduct(this.normalizedVelocityVector, true)));
            this.wingLiftCoeff = EntityVehicleF_Physics.getLiftCoeff(this.trackAngle, 2.0 + this.flapActualAngleVar.currentValue / 350.0);
            this.aileronLiftCoeff = EntityVehicleF_Physics.getLiftCoeff(this.aileronAngleVar.currentValue + this.aileronTrimVar.currentValue, 2.0);
            this.elevatorLiftCoeff = EntityVehicleF_Physics.getLiftCoeff(-2.5 + this.trackAngle - (this.elevatorAngleVar.currentValue + this.elevatorTrimVar.currentValue), 2.0);
            this.rudderLiftCoeff = EntityVehicleF_Physics.getLiftCoeff(yawAngleDelta - (this.rudderAngleVar.currentValue + this.rudderTrimVar.currentValue), 2.0);
            if (((JSONVehicle)this.definition).motorized.isBlimp) {
                this.dragCoeff = (double)0.004f * Math.pow(Math.abs(yawAngleDelta), 2.0) + this.dragCoefficientVar.currentValue;
            } else if (((JSONVehicle)this.definition).motorized.isAircraft) {
                this.dragCoeff = (double)4.0E-4f * Math.pow(this.trackAngle, 2.0) + this.dragCoefficientVar.currentValue;
            } else {
                this.dragCoeff = this.dragCoefficientVar.currentValue;
                if (this.groundDeviceCollective.groundedGroundDevices.isEmpty()) {
                    this.dragCoeff *= 3.0;
                }
            }
            this.dragForce = ((JSONVehicle)this.definition).motorized.crossSectionalArea > 0.0f ? 0.5 * this.airDensity * this.velocity * this.velocity * (double)((JSONVehicle)this.definition).motorized.crossSectionalArea * this.dragCoeff : (this.wingSpanVar.currentValue > 0.0 ? 0.5 * this.airDensity * this.velocity * this.velocity * this.wingAreaVar.currentValue * (this.dragCoeff + this.wingLiftCoeff * this.wingLiftCoeff / (Math.PI * this.wingSpanVar.currentValue * this.wingSpanVar.currentValue / this.wingAreaVar.currentValue * 0.8)) : 0.5 * this.airDensity * this.velocity * this.velocity * 5.0 * this.dragCoeff);
            if (this.ballastVolumeVar.currentValue > 0.0) {
                if (this.ballastControlVar.currentValue < 0.0) {
                    this.ballastForce = this.airDensity * this.ballastVolumeVar.currentValue * -this.ballastControlVar.currentValue / 10.0;
                } else if (this.ballastControlVar.currentValue > 0.0) {
                    this.ballastForce = 1.225 * this.ballastVolumeVar.currentValue * -this.ballastControlVar.currentValue / 10.0;
                } else if (this.motion.y < -0.15 || this.motion.y > 0.15) {
                    this.ballastForce = 1.225 * this.ballastVolumeVar.currentValue * 10.0 * -this.motion.y;
                } else {
                    this.ballastForce = 0.0;
                    this.motion.y = 0.0;
                }
                if (this.motion.y * this.ballastForce != 0.0) {
                    this.ballastForce /= Math.pow(1.0 + Math.abs(this.motion.y), 2.0);
                }
            }
            this.wingForce = 0.5 * this.airDensity * this.axialVelocity * this.axialVelocity * this.wingAreaVar.currentValue * this.wingLiftCoeff;
            if (this.hasRotors) {
                this.aileronForce = 0.0;
                this.elevatorForce = 0.0;
                this.rudderForce = 0.0;
            } else {
                this.aileronForce = 0.5 * this.airDensity * this.axialVelocity * this.axialVelocity * this.aileronAreaVar.currentValue * this.aileronLiftCoeff;
                this.elevatorForce = 0.5 * this.airDensity * this.axialVelocity * this.axialVelocity * this.elevatorAreaVar.currentValue * this.elevatorLiftCoeff;
                this.rudderForce = 0.5 * this.airDensity * this.axialVelocity * this.axialVelocity * this.rudderAreaVar.currentValue * this.rudderLiftCoeff;
            }
            this.aileronTorque = this.aileronForce * this.wingSpanVar.currentValue * 0.5 * 0.75;
            this.elevatorTorque = this.elevatorForce * (double)((JSONVehicle)this.definition).motorized.tailDistance;
            this.rudderTorque = this.rudderForce * (double)((JSONVehicle)this.definition).motorized.tailDistance;
            if (Math.abs(this.elevatorTorque) < 2.0 * this.currentMass / 400.0) {
                this.elevatorTorque = 0.0;
            }
            if (((JSONVehicle)this.definition).motorized.isBlimp) {
                this.aileronTorque = this.orientation.angles.z > 0.0 ? -Math.min(0.5, this.orientation.angles.z) * this.currentMass / 100.0 : (this.orientation.angles.z < 0.0 ? -Math.max(-0.5, this.orientation.angles.z) * this.currentMass / 100.0 : 0.0);
                this.elevatorTorque = this.orientation.angles.x > 0.0 ? -Math.min(0.5, this.orientation.angles.x) * this.currentMass / 100.0 : (this.orientation.angles.x < 0.0 ? -Math.max(-0.5, this.orientation.angles.x) * this.currentMass / 100.0 : 0.0);
                if (this.rudderTorque * this.rudderAngleVar.currentValue > 0.0) {
                    this.rudderTorque = 0.0;
                }
            }
            if (this.wingAreaVar.currentValue > 0.0 && this.trackAngle > 40.0 && this.orientation.angles.x < 45.0 && this.motion.y < -0.1 && this.groundDeviceCollective.isAnythingOnGround()) {
                this.elevatorTorque += 100.0;
            }
            if (this.outOfHealth) {
                this.wingForce = 0.0;
                this.elevatorForce = 0.0;
                this.aileronForce = 0.0;
                this.rudderForce = 0.0;
                this.elevatorTorque = 0.0;
                this.aileronTorque = 0.0;
                this.rudderTorque = 0.0;
                this.ballastForce = 0.0;
            }
            double d = this.gravitationalForce = !this.ballastVolumeVar.isActive || this.outOfHealth ? this.currentMass * 0.0245 * this.gravityFactorVar.currentValue : 0.0;
            if (this.waterBallastFactorVar.isActive && this.world.isBlockLiquid(this.position)) {
                this.gravitationalForce -= this.gravitationalForce * this.waterBallastFactorVar.currentValue;
                this.elevatorTorque = -this.orientation.angles.x * 2.0;
                this.aileronTorque = -this.orientation.angles.z * 2.0;
            }
            if ((Double)ConfigSystem.settings.general.maxFlightHeight.value > 0.0 && this.position.y > (Double)ConfigSystem.settings.general.maxFlightHeight.value) {
                this.wingForce = 0.0;
                this.thrustForce.y = 0.0;
            }
            this.totalForce.set(0.0, this.wingForce - this.elevatorForce, 0.0).rotate(this.orientation);
            this.totalForce.add(this.thrustForce);
            this.totalForce.addScaled(this.normalizedVelocityVector, -this.dragForce);
            this.totalForce.y += this.ballastForce - this.gravitationalForce;
            this.motion.addScaled(this.totalForce, 1.0 / this.currentMass);
            this.totalTorque.set(this.elevatorTorque, this.rudderTorque, this.aileronTorque).add(this.thrustTorque).scale(57.29577951308232);
            this.totalTorque.x /= this.momentPitch;
            this.totalTorque.y /= this.momentYaw;
            this.totalTorque.z /= this.momentRoll;
            this.rotation.angles.set(this.totalTorque).add(this.rotorRotation);
        } else if (!this.lockedOnRoad) {
            this.towedByConnection.hookupPriorPosition.set(this.towedByConnection.hookupCurrentPosition);
            if (this.towedByConnection.hitchConnection.mounted || this.towedByConnection.hitchConnection.restricted) {
                this.rotation.set(this.towedByConnection.towingEntity.orientation);
                if (this.towedByConnection.hitchConnection.rot != null) {
                    this.rotation.multiply(this.towedByConnection.hitchConnection.rot);
                }
                if (this.towedByConnection.hookupConnection.rot != null) {
                    this.rotation.multiply(this.towedByConnection.hookupConnection.rot);
                }
                if (this.towedByConnection.hitchConnection.restricted) {
                    this.rotation.angles.x = this.orientation.angles.x;
                    this.rotation.angles.z = this.orientation.angles.z;
                    this.rotation.updateToAngles();
                }
                this.towedByConnection.hookupCurrentPosition.set(this.towedByConnection.hookupConnection.pos).multiply(this.towedByConnection.towedEntity.scale).rotate(this.rotation).add(this.towedByConnection.towedEntity.position);
            } else if (!this.towedByConnection.hitchPriorPosition.isZero()) {
                if (this.towedByConnection.hookupConnection.pos.x != 0.0) {
                    this.hitchPrevOffset.set(-this.towedByConnection.hookupConnection.pos.x, 0.0, 0.0).rotate(this.prevOrientation);
                    this.hitchCurrentOffset.set(-this.towedByConnection.hookupConnection.pos.x, 0.0, 0.0).rotate(this.orientation);
                    this.hitchPrevOffset.add(this.towedByConnection.hitchPriorPosition).subtract(this.prevPosition);
                    this.hitchCurrentOffset.add(this.towedByConnection.hitchCurrentPosition).subtract(this.position);
                } else {
                    this.hitchPrevOffset.set(this.towedByConnection.hitchPriorPosition).subtract(this.prevPosition);
                    this.hitchCurrentOffset.set(this.towedByConnection.hitchCurrentPosition).subtract(this.position);
                }
                this.hitchPrevOffset.y = 0.0;
                this.hitchCurrentOffset.y = 0.0;
                this.hitchPrevOffset.normalize();
                this.hitchCurrentOffset.normalize();
                double rotationDelta = Math.toDegrees(Math.acos(this.hitchPrevOffset.dotProduct(this.hitchCurrentOffset, true)));
                if (this.hitchPrevOffset.crossProduct((Point3D)this.hitchCurrentOffset).y < 0.0) {
                    rotationDelta = -rotationDelta;
                }
                this.rotation.angles.set(0.0, rotationDelta, 0.0);
                this.rotation.updateToAngles();
                this.towedByConnection.hookupCurrentPosition.set(this.towedByConnection.hookupConnection.pos).multiply(this.towedByConnection.towedEntity.scale).rotate(this.towedByConnection.towedEntity.orientation).rotate(this.rotation).add(this.towedByConnection.towedEntity.position);
            }
            this.motion.set(this.towedByConnection.hitchCurrentPosition).subtract(this.towedByConnection.hookupCurrentPosition).scale(1.0 / this.speedFactor);
        } else {
            this.motion.set(this.towedByConnection.towingVehicle.motion);
            this.rotation.angles.set(0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void adjustControlSurfaces() {
        if (!((JSONVehicle)this.definition).motorized.isAircraft && this.autopilotValueVar.isActive) {
            if (this.indicatedSpeed < this.autopilotValueVar.currentValue) {
                if (this.throttleVar.currentValue < 1.0) {
                    this.throttleVar.adjustBy(0.01, true);
                }
            } else if (this.indicatedSpeed > this.autopilotValueVar.currentValue && this.throttleVar.currentValue > 0.0) {
                this.throttleVar.adjustBy(-0.01, true);
            }
        }
        if (this.hasRotors) {
            if (this.autopilotValueVar.isActive) {
                if (this.ticksExisted % 10L == 0L) {
                    if (this.motion.y < 0.0 && this.throttleVar.currentValue < 1.0) {
                        this.throttleVar.adjustBy(0.01, true);
                    } else if (this.motion.y > 0.0 && this.throttleVar.currentValue < 1.0) {
                        this.throttleVar.adjustBy(-0.01, true);
                    }
                }
                double forwardsVelocity = this.motion.dotProduct(this.headingVector, false);
                double sidewaysVelocity = this.motion.dotProduct(this.sideVector, false);
                double forwardsDelta = forwardsVelocity - this.prevMotion.dotProduct(this.headingVector, false);
                double sidewaysDelta = sidewaysVelocity - this.prevMotion.dotProduct(this.sideVector, false);
                if (forwardsDelta > 0.0 && forwardsVelocity > 0.0 && this.elevatorTrimVar.currentValue < 10.0) {
                    this.elevatorTrimVar.adjustBy(1.0, true);
                } else if (forwardsDelta < 0.0 && forwardsVelocity < 0.0 && this.elevatorTrimVar.currentValue > -10.0) {
                    this.elevatorTrimVar.adjustBy(-1.0, true);
                }
                if (sidewaysVelocity > 0.0 && sidewaysDelta > 0.0 && this.aileronTrimVar.currentValue < 10.0) {
                    this.aileronTrimVar.adjustBy(1.0, true);
                } else if (sidewaysVelocity < 0.0 && sidewaysDelta < 0.0 && this.aileronTrimVar.currentValue > -10.0) {
                    this.aileronTrimVar.adjustBy(-1.0, true);
                }
            } else {
                if (this.elevatorTrimVar.currentValue < 0.0) {
                    this.elevatorTrimVar.adjustBy(1.0, true);
                } else if (this.elevatorTrimVar.currentValue > 0.0) {
                    this.elevatorTrimVar.adjustBy(-1.0, true);
                }
                if (this.aileronTrimVar.currentValue < 0.0) {
                    this.aileronTrimVar.adjustBy(1.0, true);
                } else if (this.aileronTrimVar.currentValue > 0.0) {
                    this.aileronTrimVar.adjustBy(-1.0, true);
                }
            }
        } else if (((JSONVehicle)this.definition).motorized.isAircraft && this.autopilotValueVar.isActive) {
            if (-this.motion.y * 10.0 > this.elevatorTrimVar.currentValue + 1.0 && this.elevatorTrimVar.currentValue < 10.0) {
                this.elevatorTrimVar.adjustBy(0.1, true);
            } else if (-this.motion.y * 10.0 < this.elevatorTrimVar.currentValue - 1.0 && this.elevatorTrimVar.currentValue > -10.0) {
                this.elevatorTrimVar.adjustBy(-0.1, true);
            }
            if (-this.orientation.angles.z > this.aileronTrimVar.currentValue + 0.1 && this.aileronTrimVar.currentValue < 10.0) {
                this.aileronTrimVar.adjustBy(0.1, true);
            } else if (-this.orientation.angles.z < this.aileronTrimVar.currentValue - 0.1 && this.aileronTrimVar.currentValue > -10.0) {
                this.aileronTrimVar.adjustBy(-0.1, true);
            }
        }
        if (!this.lockedOnRoad && this.controllerCount == 0) {
            if (this.aileronInputVar.currentValue > 0.6) {
                this.aileronInputVar.increment(-0.6, 0.0, 25.0, true);
            } else if (this.aileronInputVar.currentValue < -0.6) {
                this.aileronInputVar.increment(0.6, -25.0, 0.0, true);
            } else if (this.aileronInputVar.currentValue != 0.0) {
                this.aileronInputVar.setTo(0.0, true);
            }
            if (this.elevatorInputVar.currentValue > 0.6) {
                this.elevatorInputVar.increment(-0.6, 0.0, 25.0, true);
            } else if (this.elevatorInputVar.currentValue < -0.6) {
                this.elevatorInputVar.increment(0.6, -25.0, 0.0, true);
            } else if (this.elevatorInputVar.currentValue != 0.0) {
                this.elevatorInputVar.setTo(0.0, true);
            }
            if (this.rudderInputVar.currentValue > 2.0) {
                this.rudderInputVar.increment(-2.0, 0.0, 45.0, true);
            } else if (this.rudderInputVar.currentValue < -2.0) {
                this.rudderInputVar.increment(2.0, -45.0, 0.0, true);
            } else if (this.rudderInputVar.currentValue != 0.0) {
                this.rudderInputVar.setTo(0.0, true);
            }
        }
    }

    protected double getRecursiveTowingThrust() {
        if (!this.towingConnections.isEmpty()) {
            double thrust = 0.0;
            for (TowingConnection connection : this.towingConnections) {
                if (connection.hitchConnection.mounted) continue;
                thrust += connection.towedVehicle.thrustForceValue + connection.towedVehicle.getRecursiveTowingThrust();
            }
            return thrust;
        }
        return 0.0;
    }

    protected static double getLiftCoeff(double angleOfAttack, double maxLiftCoeff) {
        if (angleOfAttack == 0.0) {
            return 0.0;
        }
        if (Math.abs(angleOfAttack) <= 18.75) {
            return maxLiftCoeff * Math.sin(1.5707963267948966 * angleOfAttack / 15.0);
        }
        if (Math.abs(angleOfAttack) <= 22.5) {
            if (angleOfAttack > 0.0) {
                return maxLiftCoeff * (0.4 + 1.0 / (angleOfAttack - 15.0));
            }
            return maxLiftCoeff * (-0.4 + 1.0 / (angleOfAttack + 15.0));
        }
        return maxLiftCoeff * Math.sin(0.5235987755982988 * angleOfAttack / 15.0);
    }

    @Override
    public ComputedVariable getOrCreateVariable(String variable) {
        if (((JSONVehicle)this.definition).motorized.isTrailer && ((JSONVehicle)this.definition).motorized.hookupVariables.contains(variable)) {
            if (this.towedByConnection != null) {
                return this.towedByConnection.towingVehicle.getOrCreateVariable(variable);
            }
            ComputedVariable computedVar = (ComputedVariable)this.computedVariables.get(variable);
            if (computedVar == null) {
                computedVar = new ComputedVariable(false);
                this.computedVariables.put(variable, computedVar);
            }
            return computedVar;
        }
        return super.getOrCreateVariable(variable);
    }

    @Override
    public ComputedVariable createComputedVariable(String variable, boolean createDefaultIfNotPresent) {
        switch (variable) {
            case "yaw": {
                return new ComputedVariable(this, variable, partialTicks -> this.orientation.angles.y, false);
            }
            case "heading": {
                return new ComputedVariable(this, variable, partialTicks -> {
                    double heading = -this.orientation.angles.y;
                    if (((Boolean)ConfigSystem.client.controlSettings.north360.value).booleanValue()) {
                        heading += 180.0;
                    }
                    while (heading < 0.0) {
                        heading += 360.0;
                    }
                    while (heading > 360.0) {
                        heading -= 360.0;
                    }
                    return heading;
                }, false);
            }
            case "pitch": {
                return new ComputedVariable(this, variable, partialTicks -> this.orientation.angles.x, false);
            }
            case "roll": {
                return new ComputedVariable(this, variable, partialTicks -> this.orientation.angles.z, false);
            }
            case "altitude": {
                return new ComputedVariable(this, variable, partialTicks -> this.position.y - this.seaLevel, false);
            }
            case "speed": {
                return new ComputedVariable(this, variable, partialTicks -> this.indicatedSpeed, false);
            }
            case "speed_scaled": {
                return new ComputedVariable(this, variable, partialTicks -> this.indicatedSpeed / this.speedFactor, false);
            }
            case "velocity": {
                return new ComputedVariable(this, variable, partialTicks -> this.velocity * this.speedFactor * 20.0, false);
            }
            case "velocity_scaled": {
                return new ComputedVariable(this, variable, partialTicks -> this.velocity * 20.0, false);
            }
            case "speed_factor": {
                return new ComputedVariable(this, variable, partialTicks -> this.speedFactor, false);
            }
            case "acceleration": {
                return new ComputedVariable(this, variable, partialTicks -> this.motion.length() - this.prevMotion.length(), false);
            }
            case "road_angle_front": {
                return new ComputedVariable(this, variable, partialTicks -> this.frontFollower != null ? this.frontFollower.getCurrentYaw() - this.orientation.angles.y : 0.0, false);
            }
            case "road_angle_rear": {
                return new ComputedVariable(this, variable, partialTicks -> this.rearFollower != null ? this.rearFollower.getCurrentYaw() - this.orientation.angles.y : 0.0, false);
            }
            case "autopilot_present": {
                return new ComputedVariable(this, variable, partialTicks -> ((JSONVehicle)this.definition).motorized.hasAutopilot ? 1.0 : 0.0, false);
            }
            case "fuel": {
                return new ComputedVariable(this, variable, partialTicks -> this.fuelTank.getFluidLevel() / (double)this.fuelTank.getMaxLevel(), false);
            }
            case "mass": {
                return new ComputedVariable(this, variable, partialTicks -> this.currentMass, false);
            }
            case "electric_power": {
                return new ComputedVariable(this, variable, partialTicks -> this.electricPower, false);
            }
            case "electric_usage": {
                return new ComputedVariable(this, variable, partialTicks -> this.electricFlow * 20.0, false);
            }
            case "engines_on": {
                return new ComputedVariable(this, variable, partialTicks -> this.enginesOn ? 1.0 : 0.0, false);
            }
            case "engines_starting": {
                return new ComputedVariable(this, variable, partialTicks -> this.enginesStarting ? 1.0 : 0.0, false);
            }
            case "engines_running": {
                return new ComputedVariable(this, variable, partialTicks -> this.enginesRunning ? 1.0 : 0.0, false);
            }
            case "reverser": {
                return new ComputedVariable(this, variable, partialTicks -> this.reverseThrustVar.isActive ? 1.0 : 0.0, false);
            }
            case "reverser_present": {
                return new ComputedVariable(this, variable, partialTicks -> this.hasReverseThrust ? 1.0 : 0.0, false);
            }
            case "locked": {
                return new ComputedVariable(this, variable, partialTicks -> this.lockedVar.isActive ? 1.0 : 0.0, false);
            }
            case "door": {
                return new ComputedVariable(this, variable, partialTicks -> this.parkingBrakeVar.isActive && this.velocity < 0.25 ? 1.0 : 0.0, false);
            }
            case "fueling": {
                return new ComputedVariable(this, variable, partialTicks -> this.beingFueled ? 1.0 : 0.0, false);
            }
            case "thrust": {
                return new ComputedVariable(this, variable, partialTicks -> this.thrustForceValue, false);
            }
            case "vertical_acceleration": {
                return new ComputedVariable(this, variable, partialTicks -> -(Math.toRadians(this.rotation.angles.x) * 20.0 * this.indicatedSpeed), false);
            }
            case "lateral_acceleration": {
                return new ComputedVariable(this, variable, partialTicks -> -(Math.toRadians(this.rotation.angles.y) * 20.0 * this.indicatedSpeed), false);
            }
            case "vertical_acceleration_scaled": {
                return new ComputedVariable(this, variable, partialTicks -> -(Math.toRadians(this.rotation.angles.x) * 20.0 * (this.indicatedSpeed / this.speedFactor)), false);
            }
            case "lateral_acceleration_scaled": {
                return new ComputedVariable(this, variable, partialTicks -> -(Math.toRadians(this.rotation.angles.y) * 20.0 * (this.indicatedSpeed / this.speedFactor)), false);
            }
            case "load_factor": {
                return new ComputedVariable(this, variable, partialTicks -> (Math.toRadians(-this.rotation.angles.x) * 20.0 * this.indicatedSpeed + 9.8) / 9.8, false);
            }
            case "load_factor_scaled": {
                return new ComputedVariable(this, variable, partialTicks -> (Math.toRadians(-this.rotation.angles.x) * 20.0 * (this.indicatedSpeed / this.speedFactor) + 9.8) / 9.8, false);
            }
            case "flaps_moving": {
                return new ComputedVariable(this, variable, partialTicks -> this.flapActualAngleVar.currentValue != this.flapDesiredAngleVar.currentValue ? 1.0 : 0.0, false);
            }
            case "flaps_increasing": {
                return new ComputedVariable(this, variable, partialTicks -> this.flapActualAngleVar.currentValue < this.flapDesiredAngleVar.currentValue ? 1.0 : 0.0, false);
            }
            case "flaps_decreasing": {
                return new ComputedVariable(this, variable, partialTicks -> this.flapActualAngleVar.currentValue > this.flapDesiredAngleVar.currentValue ? 1.0 : 0.0, false);
            }
            case "vertical_speed": {
                return new ComputedVariable(this, variable, partialTicks -> this.motion.y * this.speedFactor * 20.0, false);
            }
            case "lift_reserve": {
                return new ComputedVariable(this, variable, partialTicks -> -this.trackAngle, false);
            }
            case "turn_coordinator": {
                return new ComputedVariable(this, variable, partialTicks -> (this.rotation.angles.z / 10.0 + this.rotation.angles.y) / 0.15 * 25.0, false);
            }
            case "turn_indicator": {
                return new ComputedVariable(this, variable, partialTicks -> this.rotation.angles.y / (double)0.15f * 25.0, false);
            }
            case "pitch_indicator": {
                return new ComputedVariable(this, variable, partialTicks -> this.rotation.angles.x / (double)0.15f * 25.0, false);
            }
            case "slip": {
                return new ComputedVariable(this, variable, partialTicks -> 75.0 * this.sideVector.dotProduct(this.normalizedVelocityVector, true), false);
            }
            case "slip_degrees": {
                return new ComputedVariable(this, variable, partialTicks -> -Math.toDegrees(Math.asin(this.sideVector.dotProduct(this.normalizedVelocityVector, false))), false);
            }
            case "slip_understeer": {
                return new ComputedVariable(this, variable, partialTicks -> this.getSteeringAngle() * (1.0 - Math.max(0.0, Math.min(1.0, Math.abs(this.turningForce) / 10.0))), false);
            }
            case "gear_present": {
                return new ComputedVariable(this, variable, partialTicks -> ((JSONVehicle)this.definition).motorized.gearSequenceDuration != 0 ? 1.0 : 0.0, false);
            }
            case "gear_moving": {
                return new ComputedVariable(this, variable, partialTicks -> (this.retractGearVar.isActive ? this.gearMovementTime != ((JSONVehicle)this.definition).motorized.gearSequenceDuration : this.gearMovementTime != 0) ? 1.0 : 0.0, false);
            }
            case "beacon_connected": {
                return new ComputedVariable(this, variable, partialTicks -> this.selectedBeacon != null ? 1.0 : 0.0, false);
            }
            case "beacon_direction": {
                return new ComputedVariable(this, variable, partialTicks -> this.selectedBeacon != null ? this.orientation.angles.getClampedYDelta(Math.toDegrees(Math.atan2(this.selectedBeacon.position.x - this.position.x, this.selectedBeacon.position.z - this.position.z))) : 0.0, false);
            }
            case "beacon_bearing_setpoint": {
                return new ComputedVariable(this, variable, partialTicks -> this.selectedBeacon != null ? this.selectedBeacon.bearing : 0.0, false);
            }
            case "beacon_bearing_delta": {
                return new ComputedVariable(this, variable, partialTicks -> this.selectedBeacon != null ? this.selectedBeacon.getBearingDelta(this) : 0.0, false);
            }
            case "beacon_glideslope_setpoint": {
                return new ComputedVariable(this, variable, partialTicks -> this.selectedBeacon != null ? this.selectedBeacon.glideSlope : 0.0, false);
            }
            case "beacon_glideslope_actual": {
                return new ComputedVariable(this, variable, partialTicks -> this.selectedBeacon != null ? Math.toDegrees(Math.asin((this.position.y - this.selectedBeacon.position.y) / this.position.distanceTo(this.selectedBeacon.position))) : 0.0, false);
            }
            case "beacon_glideslope_delta": {
                return new ComputedVariable(this, variable, partialTicks -> this.selectedBeacon != null ? this.selectedBeacon.glideSlope - Math.toDegrees(Math.asin((this.position.y - this.selectedBeacon.position.y) / this.position.distanceTo(this.selectedBeacon.position))) : 0.0, false);
            }
            case "beacon_distance": {
                return new ComputedVariable(this, variable, partialTicks -> this.selectedBeacon != null ? Math.hypot(-this.selectedBeacon.position.z + this.position.z, -this.selectedBeacon.position.x + this.position.x) : 0.0, false);
            }
            case "radar_detected": {
                return new ComputedVariable(this, variable, partialTicks -> this.radarsTracking.isEmpty() ? 0.0 : 1.0, false);
            }
            case "missile_incoming": {
                return new ComputedVariable(this, variable, partialTicks -> this.missilesIncoming.isEmpty() ? 0.0 : 1.0, false);
            }
        }
        if (variable.startsWith("missile_") && !variable.endsWith("incoming")) {
            String missileVariable = variable.substring(variable.lastIndexOf("_") + 1);
            int missileNumber = ComputedVariable.getVariableNumber(variable.replaceAll("\\D", ""));
            return new ComputedVariable(this, variable, partialTicks -> {
                if (this.missilesIncoming.size() > missileNumber) {
                    switch (missileVariable) {
                        case "distance": {
                            return ((EntityBullet)this.missilesIncoming.get((int)missileNumber)).targetDistance;
                        }
                        case "direction": {
                            Point3D missilePos = ((EntityBullet)this.missilesIncoming.get((int)missileNumber)).position;
                            return Math.toDegrees(Math.atan2(-missilePos.z + this.position.z, -missilePos.x + this.position.x)) + 90.0 + this.orientation.angles.y;
                        }
                    }
                }
                return 0.0;
            }, false);
        }
        if (variable.startsWith("radar_")) {
            String[] parsedVariable = variable.split("_");
            if (parsedVariable.length == 3) {
                int radarNumber = Integer.parseInt(parsedVariable[1]) - 1;
                switch (parsedVariable[2]) {
                    case "detected": {
                        return new ComputedVariable(this, variable, partialTicks -> this.radarsTracking.size() > radarNumber ? 1.0 : 0.0, false);
                    }
                    case "distance": {
                        return new ComputedVariable(this, variable, partialTicks -> this.radarsTracking.size() > radarNumber ? ((AEntityD_Definable)this.radarsTracking.get((int)radarNumber)).position.distanceTo(this.position) : 0.0, false);
                    }
                    case "direction": {
                        return new ComputedVariable(this, variable, partialTicks -> {
                            if (this.radarsTracking.size() > radarNumber) {
                                Point3D entityPos = ((AEntityD_Definable)this.radarsTracking.get((int)radarNumber)).position;
                                return Math.toDegrees(Math.atan2(-entityPos.z + this.position.z, -entityPos.x + this.position.x)) + 90.0 + this.orientation.angles.y;
                            }
                            return 0.0;
                        }, false);
                    }
                }
            } else if (parsedVariable.length == 4) {
                List radarList;
                switch (parsedVariable[1]) {
                    case "aircraft": {
                        radarList = this.aircraftOnRadar;
                        break;
                    }
                    case "ground": {
                        radarList = this.groundersOnRadar;
                        break;
                    }
                    default: {
                        return new ComputedVariable(false);
                    }
                }
                int radarNumber = Integer.parseInt(parsedVariable[2]) - 1;
                switch (parsedVariable[3]) {
                    case "distance": {
                        return new ComputedVariable(this, variable, partialTicks -> {
                            if (radarNumber < radarList.size()) {
                                AEntityB_Existing contact = (AEntityB_Existing)radarList.get(radarNumber);
                                return contact.position.distanceTo(this.position);
                            }
                            return 0.0;
                        }, false);
                    }
                    case "direction": {
                        return new ComputedVariable(this, variable, partialTicks -> {
                            if (radarNumber < radarList.size()) {
                                double delta;
                                AEntityB_Existing contact = (AEntityB_Existing)radarList.get(radarNumber);
                                for (delta = Math.toDegrees(Math.atan2(-contact.position.z + this.position.z, -contact.position.x + this.position.x)) + 90.0 + this.orientation.angles.y; delta < -180.0; delta += 360.0) {
                                }
                                while (delta > 180.0) {
                                    delta -= 360.0;
                                }
                                return delta;
                            }
                            return 0.0;
                        }, false);
                    }
                    case "speed": {
                        return new ComputedVariable(this, variable, partialTicks -> {
                            if (radarNumber < radarList.size()) {
                                AEntityB_Existing contact = (AEntityB_Existing)radarList.get(radarNumber);
                                return contact.velocity;
                            }
                            return 0.0;
                        }, false);
                    }
                    case "altitude": {
                        return new ComputedVariable(this, variable, partialTicks -> {
                            if (radarNumber < radarList.size()) {
                                AEntityB_Existing contact = (AEntityB_Existing)radarList.get(radarNumber);
                                return contact.position.y;
                            }
                            return 0.0;
                        }, false);
                    }
                    case "angle": {
                        return new ComputedVariable(this, variable, partialTicks -> {
                            if (radarNumber < radarList.size()) {
                                AEntityB_Existing contact = (AEntityB_Existing)radarList.get(radarNumber);
                                return -Math.toDegrees(Math.atan2(-contact.position.y + this.position.y, Math.hypot(-contact.position.z + this.position.z, -contact.position.x + this.position.x))) + this.orientation.angles.x;
                            }
                            return 0.0;
                        }, false);
                    }
                }
            }
            return new ComputedVariable(false);
        }
        return super.createComputedVariable(variable, createDefaultIfNotPresent);
    }

    @Override
    public void renderBoundingBoxes(TransformationMatrix transform) {
        super.renderBoundingBoxes(transform);
        if (this.towedByConnection == null || !this.towedByConnection.hitchConnection.mounted) {
            for (BoundingBox box : this.groundDeviceCollective.getGroundBounds()) {
                box.renderWireframe(this, transform, null, ColorRGB.BLUE);
            }
        }
    }
}

